<?php
namespace VM\FinancialStatementsBundle\Services;

use VM\FinancialStatementsBundle\Services\DataStructure\FinansowanieInwestycjiDS;
use VM\FinancialStatementsBundle\Services\DataStructure\FinansowanieProdukcjiDS;
use VM\FinancialStatementsBundle\Services\DataStructure\SprawozdaniaDS;

class Gra
{
    protected $FinansowanieInwestycjiPodsumowanie;
//    protected $LokatyPodsumowanie;
    protected $FinansowanieProdukcji;

    /**
     * @var Sprawozdania
     */
    protected $Sprawozdania;
    protected $SprawozdawczoscUproszczona;

    /**
     * @var array
     */
    protected $FinansowanieInwestycjiDSObecnaTura = array();

    protected $FinansowanieProdukcjiDSObecnaTura;

    /**
     * @var int
     */
    protected $kapitalPodstawowy = 2000000;

    /**
     * @var int
     */
    protected $numerIteracji = 0;

    /**
     * @var int
     */
    protected $rokPoczatkowy = 1;

    /**
     * @var int
     */
    public $liczbaLat = 8;

    /**
     * @var array
     */
    protected $przychodyFinansowe = array();
    protected $lokatyWziete = array();
    protected $lokatySplacone = array();

    /**
     * @var array
     */
    protected $kredytObrotowy = array();

    /**
     * @var array
     */
    protected $kredytObrotowySplata = array();

    /**
     * @var array
     */
    protected $odsetkiKredytuObrotowego = array();
    /**
     * Constructor
     */
    public function __construct($rokPoczatkowy)
    {
        $this->FinansowanieInwestycjiPodsumowanie = new FinansowanieInwestycjiPodsumowanie();

//        $this->LokatyPodsumowanie = new LokatyPodsumowanie();

        $this->rokPoczatkowy = $rokPoczatkowy;
    }

    public function addFinansowanieInwestycji(FinansowanieInwestycjiDS $FinansowanieInwestycjiDS)
    {
        if($FinansowanieInwestycjiDS instanceof FinansowanieInwestycjiDS)
        {
            $FinansowanieInwestycjiDS->rokPoczatkowy = $this->rokPoczatkowy + $this->numerIteracji;
            $FinansowanieInwestycjiDS->liczbaLat = $this->liczbaLat - $this->numerIteracji;
            $this->FinansowanieInwestycjiDSObecnaTura[] = $FinansowanieInwestycjiDS;
        }
    }

    public function addPrzychodyFinansowe($przychody, $lokatyWziete, $lokatySplacone)
    {
        $this->przychodyFinansowe[$this->rokPoczatkowy+$this->numerIteracji] = $przychody;
        $this->lokatyWziete[$this->rokPoczatkowy+$this->numerIteracji] = $lokatyWziete;
        $this->lokatySplacone[$this->rokPoczatkowy+$this->numerIteracji] = $lokatySplacone;
    }

    public function addKredytObrotowy($kredyt)
    {
        $this->kredytObrotowy[$this->rokPoczatkowy+$this->numerIteracji] = $kredyt;
        if(isset($this->kredytObrotowy[$this->rokPoczatkowy+$this->numerIteracji - 1]))
        {
            $poprzedniKredyt = $this->kredytObrotowy[$this->rokPoczatkowy+$this->numerIteracji - 1];
            if($kredyt['id'] == 0)
            {
                if($poprzedniKredyt['id'] != 0)
                {
                    $this->removeKredytObrotowy($poprzedniKredyt);
                }
            }
            else if($poprzedniKredyt['id'] != 0)
            {
                if($poprzedniKredyt['id'] == $kredyt['id'])
                {
                    $this->kredytObrotowy[$this->rokPoczatkowy+$this->numerIteracji]['value'] = 0;
                }
                else
                {
                    $this->removeKredytObrotowy($poprzedniKredyt);
                }
            }
        }
    }

    public function removeKredytObrotowy($kredyt)
    {
        $this->kredytObrotowySplata[$this->rokPoczatkowy+$this->numerIteracji] = $kredyt;
    }

    public function addOdsetkiKredytuObrotowego($odsetki)
    {
        $this->odsetkiKredytuObrotowego[$this->rokPoczatkowy+$this->numerIteracji] = $odsetki;
    }

    public function addFinansowanieProdukcji(FinansowanieProdukcjiDS $FinansowanieProdukcjiDS)
    {
        $FinansowanieProdukcjiDS->rokPoczatkowy = $this->rokPoczatkowy;
        $this->FinansowanieProdukcjiDSObecnaTura = $FinansowanieProdukcjiDS;
    }

    public function evalAndGetNextIteration()
    {
        if(!$this->FinansowanieProdukcjiDSObecnaTura instanceof FinansowanieProdukcjiDS)
        {
            throw new \Exception('Niepoprawny obiekt FinansowanieProdukcjiDS.');
        }

        if(!isset($this->przychodyFinansowe[$this->rokPoczatkowy+$this->numerIteracji]))
        {
            $this->przychodyFinansowe[$this->rokPoczatkowy+$this->numerIteracji] = 0;
        }
        if(!isset($this->lokaty[$this->rokPoczatkowy+$this->numerIteracji]))
        {
            $this->lokaty[$this->rokPoczatkowy+$this->numerIteracji] = 0;
        }
        $emptyCredit = array();
        $emptyCredit['id'] = 0;
        $emptyCredit['value'] = 0;
        $emptyCredit['fullValue'] = 0;
        if(!isset($this->kredytObrotowy[$this->rokPoczatkowy+$this->numerIteracji]))
        {
            $this->kredytObrotowy[$this->rokPoczatkowy+$this->numerIteracji] = $emptyCredit;
        }
        if(!isset($this->kredytObrotowySplata[$this->rokPoczatkowy+$this->numerIteracji]))
        {
            $this->kredytObrotowySplata[$this->rokPoczatkowy+$this->numerIteracji] = $emptyCredit;
        }
        if(!isset($this->odsetkiKredytuObrotowego[$this->rokPoczatkowy+$this->numerIteracji]))
        {
            $this->odsetkiKredytuObrotowego[$this->rokPoczatkowy+$this->numerIteracji] = 0;
        }

        $this->numerIteracji++;

        if(!($this->FinansowanieProdukcji instanceof FinansowanieProdukcji))
        {
            $this->FinansowanieProdukcji = FinansowanieProdukcji::create($this->FinansowanieProdukcjiDSObecnaTura);
            $this->evaluateSprawozdaniaISprawozdawczosc();
        }
        else
        {
            $this->FinansowanieProdukcji->nextIteration($this->FinansowanieProdukcjiDSObecnaTura);
            $this->evaluateSprawozdaniaISprawozdawczosc();
        }

        $this->FinansowanieInwestycjiDSObecnaTura = array();

        return $this->SprawozdawczoscUproszczona->getSprawozdawczoscUproszczona();
    }

    // return Array
    // dwa klucze
    // 'sprzedano' - liczba sztuk sprzedanych
    // 'wyprodukowano' - liczba sztuk wyprodukowanych
    // 'podatekDochodowy'
    public function getProductionData()
    {
        return $this->Sprawozdania->getProductionData();
    }

    public function getSprawozdania()
    {
        return $this->Sprawozdania->getAll();
    }

    protected function evaluateSprawozdaniaISprawozdawczosc()
    {
        foreach($this->FinansowanieInwestycjiDSObecnaTura as $inw)
        {
            $this->FinansowanieInwestycjiPodsumowanie->addFinansowanieInwestycji(FinansowanieInwestycji::create($inw));
        }

        $SprawozdaniaDS = new SprawozdaniaDS();
        $SprawozdaniaDS->FinansowanieProdukcji = $this->FinansowanieProdukcji;
        $SprawozdaniaDS->PodsumowanieFinansowaniaInwestycji = $this->FinansowanieInwestycjiPodsumowanie;
//        $SprawozdaniaDS->LokatyPodsumowanie = $this->LokatyPodsumowanie;
        $SprawozdaniaDS->kapitalPodstawowy = $this->kapitalPodstawowy;
        $SprawozdaniaDS->rokPoczatkowy = $this->FinansowanieProdukcji->getResultsOf('rokPoczatkowy');
        $SprawozdaniaDS->ileIteracji = $this->numerIteracji;
        $SprawozdaniaDS->przychodyFinansowe = $this->przychodyFinansowe;
        $SprawozdaniaDS->lokatyWziete = $this->lokatyWziete;
        $SprawozdaniaDS->lokatySplacone = $this->lokatySplacone;
        $SprawozdaniaDS->kredytObrotowy = $this->kredytObrotowy;
        $SprawozdaniaDS->kredytObrotowySplata = $this->kredytObrotowySplata;
        $SprawozdaniaDS->odsetkiKredytuObrotowego = $this->odsetkiKredytuObrotowego;

        $Sprawozdania = Sprawozdania::create($SprawozdaniaDS);
        $this->Sprawozdania = $Sprawozdania;

        $this->SprawozdawczoscUproszczona = new SprawozdawczoscUproszczona($Sprawozdania);
    }

    public function getAll()
    {
        $all = array();

        $all['numerIteracji'] = $this->numerIteracji;
        $all['rokPoczatkowy'] = $this->rokPoczatkowy;
        $all['liczbaLat'] = $this->liczbaLat;
        $all['przychodyFinansowe'] = $this->przychodyFinansowe[$this->rokPoczatkowy+$this->numerIteracji];
        $all['lokatyWziete'] =
            isset($this->lokatyWziete[$this->rokPoczatkowy+$this->numerIteracji])?
                $this->lokatyWziete[$this->rokPoczatkowy+$this->numerIteracji]: 0;
        $all['lokatySplacone'] =
            isset($this->lokatySplacone[$this->rokPoczatkowy+$this->numerIteracji])?
                $this->lokatySplacone[$this->rokPoczatkowy+$this->numerIteracji]: 0;
        $emptyCredit = array();
        $emptyCredit['id'] = 0;
        $emptyCredit['value'] = 0;
        $emptyCredit['fullValue'] = 0;
        $all['kredytObrotowy'] = isset($this->kredytObrotowy[$this->rokPoczatkowy+$this->numerIteracji])?
            $this->kredytObrotowy[$this->rokPoczatkowy+$this->numerIteracji]: $emptyCredit;
        $all['kredytObrotowySplata'] =
            isset($this->kredytObrotowySplata[$this->rokPoczatkowy+$this->numerIteracji])?
                $this->kredytObrotowySplata[$this->rokPoczatkowy+$this->numerIteracji]: $emptyCredit;
        $all['odsetkiKredytuObrotowego'] = $this->odsetkiKredytuObrotowego[$this->rokPoczatkowy+$this->numerIteracji];

        $all['finansowanieInwestycji'] = array();
        for($i = 0; $i < count($this->FinansowanieInwestycjiDSObecnaTura); $i++)
        {
            $all['finansowanieInwestycji'][$i] = array();
            $all['finansowanieInwestycji'][$i]['naklady'] = $this->FinansowanieInwestycjiDSObecnaTura[$i]->naklady;
            $all['finansowanieInwestycji'][$i]['procentAmortyzacji'] = $this->FinansowanieInwestycjiDSObecnaTura[$i]->procentAmortyzacji;
            $all['finansowanieInwestycji'][$i]['rokPoczatkowy'] = $this->FinansowanieInwestycjiDSObecnaTura[$i]->rokPoczatkowy;
            $all['finansowanieInwestycji'][$i]['liczbaLat'] = $this->FinansowanieInwestycjiDSObecnaTura[$i]->liczbaLat;
            $all['finansowanieInwestycji'][$i]['czyKapitalWlasny'] = $this->FinansowanieInwestycjiDSObecnaTura[$i]->czyKapitalWlasny;
            $all['finansowanieInwestycji'][$i]['czyKredyt'] = $this->FinansowanieInwestycjiDSObecnaTura[$i]->czyKredyt;
            $all['finansowanieInwestycji'][$i]['czyLeasing'] = $this->FinansowanieInwestycjiDSObecnaTura[$i]->czyLeasing;
            $all['finansowanieInwestycji'][$i]['czyNaSrodkiTrwale'] = $this->FinansowanieInwestycjiDSObecnaTura[$i]->czyNaSrodkiTrwale;
            $all['finansowanieInwestycji'][$i]['kapitalWlasny'] = $this->FinansowanieInwestycjiDSObecnaTura[$i]->kapitalWlasny;
            $all['finansowanieInwestycji'][$i]['kapitalObcy'] = $this->FinansowanieInwestycjiDSObecnaTura[$i]->kapitalObcy;
            $all['finansowanieInwestycji'][$i]['oprocentowanieKredytuLubLeasingu'] = $this->FinansowanieInwestycjiDSObecnaTura[$i]->oprocentowanieKredytuLubLeasingu;
            $all['finansowanieInwestycji'][$i]['okresKredytuLubLeasingu'] = $this->FinansowanieInwestycjiDSObecnaTura[$i]->okresKredytuLubLeasingu;
            $all['finansowanieInwestycji'][$i]['ostatniaWplataLeasingu'] = $this->FinansowanieInwestycjiDSObecnaTura[$i]->ostatniaWplataLeasingu;
        }

        $all['finansowanieProdukcji'] = array();
        $all['finansowanieProdukcji']['rokPoczatkowy'] = $this->FinansowanieProdukcjiDSObecnaTura->rokPoczatkowy;
        $all['finansowanieProdukcji']['udzialWRynku'] = $this->FinansowanieProdukcjiDSObecnaTura->udzialWRynku;
        $all['finansowanieProdukcji']['cenaProduktu'] = $this->FinansowanieProdukcjiDSObecnaTura->cenaProduktu;
        $all['finansowanieProdukcji']['nakladyNaPiR'] = $this->FinansowanieProdukcjiDSObecnaTura->nakladyNaPiR;
        $all['finansowanieProdukcji']['nakladyNaInnowacje'] = $this->FinansowanieProdukcjiDSObecnaTura->nakladyNaInnowacje;
        $all['finansowanieProdukcji']['mozliwosciProdukcyjne'] = $this->FinansowanieProdukcjiDSObecnaTura->mozliwosciProdukcyjne;
        $all['finansowanieProdukcji']['kosztyStale'] = $this->FinansowanieProdukcjiDSObecnaTura->kosztyStale;
        $all['finansowanieProdukcji']['kosztyZmienne'] = $this->FinansowanieProdukcjiDSObecnaTura->kosztyZmienne;
        $all['finansowanieProdukcji']['wielkoscRynku'] = $this->FinansowanieProdukcjiDSObecnaTura->wielkoscRynku;
        $all['finansowanieProdukcji']['planowanaProdukcja'] = $this->FinansowanieProdukcjiDSObecnaTura->planowanaProdukcja;
        $all['finansowanieProdukcji']['bazowyKosztProdukcji'] = $this->FinansowanieProdukcjiDSObecnaTura->bazowyKosztProdukcji;
        $all['finansowanieProdukcji']['obnizkaBrakow'] = $this->FinansowanieProdukcjiDSObecnaTura->obnizkaBrakow;

        return $all;
    }

    public function setAll($all)
    {
        $this->numerIteracji = $all['numerIteracji'];
        $this->rokPoczatkowy = $all['rokPoczatkowy'];
        $this->liczbaLat = $all['liczbaLat'];
        $this->przychodyFinansowe[$this->rokPoczatkowy + $this->numerIteracji] = $all['przychodyFinansowe'];
        $this->lokatyWziete[$this->rokPoczatkowy + $this->numerIteracji] = isset($all['lokatyWziete'])? $all['lokatyWziete']: 0;
        $this->lokatySplacone[$this->rokPoczatkowy + $this->numerIteracji] = isset($all['lokatySplacone'])? $all['lokatySplacone']: 0;
        $emptyCredit = array();
        $emptyCredit['id'] = 0;
        $emptyCredit['value'] = 0;
        $emptyCredit['fullValue'] = 0;
        $this->kredytObrotowy[$this->rokPoczatkowy + $this->numerIteracji] = isset($all['kredytObrotowy'])? $all['kredytObrotowy']: $emptyCredit;
        $this->kredytObrotowySplata[$this->rokPoczatkowy + $this->numerIteracji] = isset($all['kredytObrotowySplata'])? $all['kredytObrotowySplata']: $emptyCredit;
        $this->odsetkiKredytuObrotowego[$this->rokPoczatkowy + $this->numerIteracji] = $all['odsetkiKredytuObrotowego'];

        for($i = 0; $i < count($all['finansowanieInwestycji']); $i++)
        {
            $inw = new FinansowanieInwestycjiDS();
            foreach($all['finansowanieInwestycji'][$i] as $key => $value)
            {
                $inw->$key = $value;
            }

            $this->FinansowanieInwestycjiDSObecnaTura[$i] = $inw;
        }

        $prod = new FinansowanieProdukcjiDS();
        foreach($all['finansowanieProdukcji'] as $key => $value)
        {
            $prod->$key = $value;
        }

        $this->FinansowanieProdukcjiDSObecnaTura = $prod;

    }
}

?>
